﻿using System.Web.Caching;

namespace Framework.Data
{
    /// <summary>
    /// リストソースのリクエストの引数
    /// </summary>
    public class ListSrcRequestArgs
    {
        /// <summary>
        /// リストデータのデータソース。呼び出された側でセットします。
        /// </summary>
        public ListSrcDataSet ListSrc;

        /// <summary>
        /// キャッシュの依存関係。呼び出された側でセットします。
        /// </summary>
        public CacheDependency CacheDependency;
    }

    /// <summary>
    /// リストソースのリクエストリスナーのインターフェース
    /// </summary>
    public interface IListSrcRequestListener
    {
        /// <summary>
        /// リストソースのリクエスト
        /// </summary>
        /// <param name="arg"></param>
        void RequestListSrc(ListSrcRequestArgs arg);
    }
}
